/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Vector;
import jclass.chart.ChartDataView;
import jclass.chart.ChartDataViewSeries;
import jclass.chart.ChartDraw;
import jclass.chart.ChartText;
import jclass.chart.JCChartUtil;
import jclass.chart.JCDataIndex;
import jclass.chart.JCFillStyle;
import jclass.chart.JCPieChartFormat;
import jclass.chart.PieChartInfo;
import jclass.chart.PieData;
import jclass.chart.PiePercent;
import jclass.chart.PiePosition;
import jclass.chart.PieSortAscending;
import jclass.chart.PieSortDescending;
import jclass.chart.PieSortPoint;
import jclass.util.JCSortInterface;
import jclass.util.JCqsort;

class PieChartDraw
extends ChartDraw {
    public static final int COORD_DEFAULT_VALUE = -2;
    public static final int COORD_ZERO_SLICE = -1;
    public static final int INDEX_HOLE = -2;
    public static final int INDEX_NOT_DRAWN = -1;
    public static final int HIT_NOWHERE = 0;
    public static final int HIT_TOP = 1;
    public static final int HIT_EDGE = 2;
    int num_pies;
    int num_lines;
    int num_pies_line;
    int box_width;
    int box_height;
    int pie_offset;
    int first_point;
    int graph_left;
    int graph_top;
    transient ChartText[] cLabels;
    int label_height;
    int explode_offset;

    public PieChartDraw(ChartDataView dataObject) {
        super(dataObject);
    }

    public void recalc() {
        this.calcTransientData();
        PieChartInfo pPie = (PieChartInfo)this.dataObject.getTransientData();
        ChartDataViewSeries[] seriesList = this.dataObject.getSeries();
        Rectangle pa = this.chartArea.plotRect;
        this.graph_left = pa.x;
        this.graph_top = pa.y;
        int graph_width = Math.max(pa.width, 0);
        int graph_height = Math.max(pa.height, 0);
        int numLabels = this.dataObject.getNumPointLabels();
        String[] pLabels = new String[numLabels];
        this.cLabels = new ChartText[numLabels];
        this.label_height = 0;
        int i = 0;
        while (i < numLabels) {
            pLabels[i] = this.dataObject.getPointLabel(i);
            if (pLabels[i] != null) {
                this.cLabels[i] = new ChartText();
                this.cLabels[i].setText(pLabels[i], true);
                this.cLabels[i].setParent(this.chartArea);
                this.cLabels[i].recalc();
                int cHeight = this.cLabels[i].getHeight();
                this.label_height = Math.max(this.label_height, cHeight);
            } else {
                this.cLabels[i] = null;
            }
            ++i;
        }
        int num_slices = this.dataObject.getNumSeries();
        if (this.num_pies == 0) {
            return;
        }
        int[] passback = this.pieLayout(this.num_pies, pa);
        this.num_lines = passback[0];
        this.num_pies_line = passback[1];
        this.box_width = graph_width / this.num_pies_line;
        this.box_height = graph_height / this.num_lines;
        JCPieChartFormat pie_format = this.dataObject.getPieChartFormat();
        this.explode_offset = pie_format.getExplodeList() == null ? 0 : pie_format.getExplodeOffset();
        int avail_width = Math.max(this.box_width - this.label_height * 2 - this.explode_offset * 2, 0);
        int avail_height = Math.max(this.box_height - this.label_height * 2 - this.explode_offset * 2, 0);
        double elevation = pie_format.getExplodeList() == null ? JCChartUtil.degToRad(Math.max(0, this.chartArea.getElevation())) : 0.0;
        double sin_elevation = Math.sin(elevation);
        double cos_elevation = Math.cos(elevation);
        double factor = (double)this.chartArea.getDepth() / 100.0;
        int pie_width = 0;
        pie_width = (double)avail_width * (cos_elevation + factor * sin_elevation) < (double)avail_height ? avail_width : (int)((double)avail_height / (cos_elevation + factor * sin_elevation));
        int pie_height = (int)((double)pie_width * cos_elevation);
        this.chartArea.deltaX = 0;
        this.chartArea.deltaY = (int)((double)pie_width * factor * sin_elevation);
        if (pie_width != (pie_width | 1)) {
            pie_width = (pie_width | 1) - 2;
        }
        if (pie_height != (pie_height | 1)) {
            pie_height = (pie_height | 1) - 2;
        }
        pPie.width = pie_width;
        pPie.height = pie_height;
        this.pie_offset = (int)((double)(this.box_width - pie_width) / 2.0);
        if (this.pie_offset < 0) {
            this.pie_offset = 0;
        }
    }

    public void draw(Graphics gc) {
        gc.translate(this.chartArea.plotRect.x, this.chartArea.plotRect.y);
        if (this.dataObject.getTransientData() == null) {
            this.recalc();
        }
        PieChartInfo pPie = (PieChartInfo)this.dataObject.getTransientData();
        ChartDataViewSeries[] seriesList = this.dataObject.getSeries();
        Rectangle pa = this.chartArea.plotRect;
        if (this.num_pies == 0) {
            return;
        }
        int pie_num = 0;
        int box_x = this.graph_left;
        int box_y = this.graph_top;
        int k = 0;
        while (k < this.num_lines) {
            int l = 0;
            while (l < this.num_pies_line) {
                int x = box_x + this.pie_offset;
                int y = box_y + (this.box_height - pPie.height - this.chartArea.deltaY - this.label_height) / 2;
                if (pie_num < this.num_pies) {
                    ChartText pie_label;
                    if (!pPie.data[pie_num].zero_pie) {
                        if (this.chartArea.deltaY != 0) {
                            this.drawPiePlane(gc, seriesList, pPie.data[pie_num], pPie, x, y + this.chartArea.deltaY, pie_num, false);
                            this.drawPieEdge(gc, pPie.data[pie_num], pPie, x, y);
                        }
                        this.drawPiePlane(gc, seriesList, pPie.data[pie_num], pPie, x, y, pie_num, true);
                        this.drawPieLines(gc, seriesList, pPie.data[pie_num], pPie, x, y, pie_num);
                    }
                    if (pie_num + this.first_point < this.cLabels.length && (pie_label = this.cLabels[pie_num + this.first_point]) != null) {
                        int cWidth = pie_label.getWidth();
                        int cHeight = pie_label.getHeight();
                        pie_label.move(box_x + (this.box_width - cWidth) / 2, y + pPie.height + this.chartArea.deltaY + this.explode_offset);
                        pie_label.draw(gc);
                    }
                    if (!pPie.data[pie_num].zero_pie) {
                        this.drawPieCircle(gc, seriesList, pPie.data[pie_num], pPie, x, y, pie_num);
                    }
                }
                ++pie_num;
                box_x += this.box_width;
                ++l;
            }
            box_x = this.graph_left;
            box_y += this.box_height;
            ++k;
        }
    }

    private int[] pieLayout(int num_pies, Rectangle plotRect) {
        double balance_metric;
        int num_pies_line = plotRect.height == 0 ? num_pies : (int)Math.min((double)num_pies, Math.sqrt(num_pies) * (double)plotRect.width / (double)plotRect.height);
        if (num_pies_line < 1) {
            num_pies_line = 1;
        }
        if ((balance_metric = (double)(num_pies % num_pies_line) / (double)num_pies_line) == 0.0) {
            balance_metric = 1.0;
        }
        int m = num_pies_line;
        while (m > 1) {
            double tmp_bmetric = (double)(num_pies % m) / (double)m;
            if (tmp_bmetric > balance_metric || tmp_bmetric == 0.0) {
                num_pies_line = m;
                if (tmp_bmetric == 0.0) {
                    balance_metric = 1.0;
                    m = 1;
                } else {
                    balance_metric = tmp_bmetric;
                }
            }
            --m;
        }
        int num_lines = num_pies / num_pies_line;
        if ((double)num_lines != (double)num_pies / (double)num_pies_line) {
            // empty if block
        }
        int[] passback = new int[]{++num_lines, num_pies_line};
        return passback;
    }

    private int computeOtherSlice(ChartDataViewSeries[] seriesList, int pie_num, int num_slices, PieData pie_data) {
        int i;
        JCPieChartFormat pie_format = this.dataObject.getPieChartFormat();
        int min_pie_slices = Math.min(num_slices, pie_format.getMinSlices());
        double pie_threshold_value = pie_format.getThresholdValue() / 100.0;
        double ysum = 0.0;
        int i2 = 0;
        while (i2 < num_slices) {
            double y = seriesList[i2].getY(pie_num);
            pie_data.sortPoints[i2].index = i2;
            if (y == this.dataObject.getHoleValue() || !seriesList[i2].isShowing) {
                y = 0.0;
                pie_data.sortPoints[i2].index = -2;
            } else if (y < 0.0) {
                y = 0.0;
            }
            ysum += y;
            pie_data.sortPoints[i2].y = y;
            ++i2;
        }
        pie_data.zero_pie = ysum == 0.0;
        switch (pie_format.sortOrder) {
            case 1: {
                this.sortWrapper(pie_data, num_slices, new PieSortAscending());
                break;
            }
            case 2: {
                this.sortWrapper(pie_data, num_slices, new PieSortDescending());
                break;
            }
        }
        Point[] exList = pie_format.getExplodeList();
        if (exList != null) {
            i = 0;
            while (i < exList.length) {
                if (pie_num == exList[i].x) {
                    if (exList[i].y == -10) {
                        pie_data.exploded[pie_data.exploded.length - 1] = true;
                    } else {
                        int j = 0;
                        while (j < num_slices) {
                            if (pie_data.sortPoints[j].index == exList[i].y) {
                                pie_data.exploded[j] = true;
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        i = 0;
        while (i < num_slices) {
            pie_data.percents[i].pct = pie_data.zero_pie ? 0.0 : pie_data.sortPoints[i].y / ysum;
            pie_data.percents[i].index = pie_data.sortPoints[i].index;
            ++i;
        }
        pie_data.other_slice = -1;
        boolean other_flag = false;
        double pct_sum = 0.0;
        int m = 0;
        int num_slices_pie = num_slices;
        boolean incl_other = true;
        switch (pie_format.sortOrder) {
            case 1: {
                int i3 = 0;
                while (i3 < num_slices) {
                    if (num_slices - i3 < min_pie_slices) break;
                    switch (pie_format.thresholdMethod) {
                        case 1: {
                            incl_other = pct_sum + pie_data.percents[i3].pct < pie_threshold_value;
                            break;
                        }
                        case 0: {
                            incl_other = pie_data.percents[i3].pct < pie_threshold_value;
                            break;
                        }
                        default: {
                            System.out.println("Big Error!");
                        }
                    }
                    if (incl_other) {
                        pie_data.percents[i3].pct += pct_sum;
                        pct_sum = pie_data.percents[i3].pct;
                        other_flag = true;
                        m = i3;
                    }
                    ++i3;
                }
                if (!other_flag) break;
                num_slices_pie = num_slices - m;
                pie_data.other_slice = num_slices_pie - 1;
                pie_data.percents[num_slices].pct = pie_data.percents[m].pct;
                pie_data.percents[num_slices].index = pie_data.percents[m].index;
                pie_data.exploded[num_slices] = pie_data.exploded[m];
                i3 = m + 1;
                while (i3 <= num_slices) {
                    pie_data.percents[i3 - m - 1].pct = pie_data.percents[i3].pct;
                    pie_data.percents[i3 - m - 1].index = pie_data.percents[i3].index;
                    pie_data.exploded[i3 - m - 1] = pie_data.exploded[i3];
                    ++i3;
                }
                break;
            }
            case 2: {
                m = num_slices - 1;
                int i4 = num_slices - 1;
                while (i4 >= 0) {
                    if (i4 + 1 < min_pie_slices) break;
                    switch (pie_format.thresholdMethod) {
                        case 1: {
                            incl_other = pct_sum + pie_data.percents[i4].pct < pie_threshold_value;
                            break;
                        }
                        case 0: {
                            incl_other = pie_data.percents[i4].pct < pie_threshold_value;
                            break;
                        }
                        default: {
                            System.out.println("Big Error!");
                        }
                    }
                    if (!incl_other) break;
                    pie_data.percents[i4].pct += pct_sum;
                    pct_sum = pie_data.percents[i4].pct;
                    m = i4--;
                    other_flag = true;
                }
                num_slices_pie = m + 1;
                pie_data.other_slice = m;
                break;
            }
            case 0: {
                this.sortWrapper(pie_data, num_slices, new PieSortAscending());
                pie_data.percents[num_slices].pct = 0.0;
                int i5 = 0;
                while (i5 < num_slices) {
                    if (num_slices_pie < min_pie_slices) break;
                    double tmp_pct = pie_data.zero_pie ? 0.0 : pie_data.sortPoints[i5].y / ysum;
                    switch (pie_format.thresholdMethod) {
                        case 1: {
                            incl_other = pct_sum + tmp_pct < pie_threshold_value;
                            break;
                        }
                        case 0: {
                            incl_other = tmp_pct < pie_threshold_value;
                            break;
                        }
                        default: {
                            System.out.println("Big Error!");
                        }
                    }
                    if (incl_other) {
                        pie_data.percents[num_slices_pie].pct += tmp_pct;
                        pct_sum = pie_data.percents[num_slices_pie].pct;
                        m = 0;
                        while (m < num_slices_pie) {
                            if (pie_data.percents[m].pct == tmp_pct) {
                                ++m;
                                break;
                            }
                            ++m;
                        }
                        while (m <= num_slices_pie) {
                            pie_data.percents[m - 1].pct = pie_data.percents[m].pct;
                            pie_data.percents[m - 1].index = pie_data.percents[m].index;
                            pie_data.exploded[m - 1] = pie_data.exploded[m];
                            ++m;
                        }
                        other_flag = true;
                        --num_slices_pie;
                    }
                    ++i5;
                }
                if (!other_flag) break;
                pie_data.other_slice = num_slices_pie++;
                break;
            }
            default: {
                System.out.println("Big Error!");
            }
        }
        pie_data.num_slices_pie = num_slices_pie;
        pie_data.other_flag = other_flag ? 1 : 0;
        return pie_data.other_flag;
    }

    private void drawPiePlane(Graphics gc, ChartDataViewSeries[] seriesList, PieData pie_data, PieChartInfo pPie, int x, int y, int pie_num, boolean is_top) {
        double start_angle = 135.0;
        int slice = 0;
        while (slice < pie_data.num_slices_pie) {
            JCFillStyle fstyle = this.getPieSliceFillStyle(pie_data, slice);
            double arc_angle = pie_data.percents[slice].pct * 360.0;
            if (slice == pie_data.lastDrawnSlice && (arc_angle = start_angle - 135.0) <= 0.0) {
                arc_angle += 360.0;
            }
            if (arc_angle != 0.0) {
                int int_angle = (int)Math.round(arc_angle);
                if (int_angle != 0) {
                    if (pie_data.exploded[slice]) {
                        int bisected_angle = int_angle / 2;
                        this.calcExplodeOffset((int)Math.round(start_angle), bisected_angle, this.explode_offset, pPie.width / 2, pPie.pos[pie_num].offset[slice]);
                    }
                    Point offset = pPie.pos[pie_num].offset[slice];
                    if (is_top) {
                        fstyle.fillArc(gc, x + offset.x, y + offset.y, pPie.width, pPie.height, (int)Math.round(start_angle), -1 * int_angle);
                    } else {
                        fstyle.fillArcShadow(gc, x + offset.x, y + offset.y, pPie.width, pPie.height, (int)Math.round(start_angle), -1 * int_angle);
                    }
                }
                if ((start_angle -= (double)int_angle) < 0.0) {
                    start_angle += 360.0;
                }
            }
            ++slice;
        }
    }

    private void drawPieCircle(Graphics gc, ChartDataViewSeries[] seriesList, PieData pie_data, PieChartInfo pPie, int x, int y, int pie_num) {
        double start_angle = 135.0;
        int undrawn_angle = 0;
        if (gc.getColor() != this.chartArea.getForeground()) {
            gc.setColor(this.chartArea.getForeground());
        }
        int slice = 0;
        while (slice < pie_data.num_slices_pie) {
            JCFillStyle fstyle = this.getPieSliceFillStyle(pie_data, slice);
            double arc_angle = pie_data.percents[slice].pct * 360.0;
            if (slice == pie_data.lastDrawnSlice) {
                if (!pie_data.exploded[slice]) {
                    undrawn_angle = 0;
                }
                if ((arc_angle = start_angle - (double)undrawn_angle - 135.0) <= 0.0) {
                    arc_angle += 360.0;
                }
            }
            if (arc_angle != 0.0) {
                int int_angle = (int)Math.round(arc_angle);
                if (pie_data.exploded[slice]) {
                    if (undrawn_angle != 0) {
                        gc.drawArc(x, y, pPie.width, pPie.height, (int)Math.round(start_angle), -1 * undrawn_angle);
                        start_angle -= (double)undrawn_angle;
                        if (start_angle < 0.0) {
                            start_angle += 360.0;
                        }
                        undrawn_angle = 0;
                    }
                    if (int_angle != 0) {
                        Point offset = pPie.pos[pie_num].offset[slice];
                        gc.drawArc(x + offset.x, y + offset.y, pPie.width, pPie.height, (int)Math.round(start_angle), -1 * int_angle);
                        start_angle -= (double)Math.round(arc_angle);
                        if (start_angle < 0.0) {
                            start_angle += 360.0;
                        }
                    }
                } else {
                    undrawn_angle += int_angle;
                }
            }
            ++slice;
        }
        if (undrawn_angle != 0) {
            gc.drawArc(x, y, pPie.width, pPie.height, (int)Math.round(start_angle), -1 * undrawn_angle);
        }
    }

    private void drawPieEdge(Graphics gc, PieData pie_data, PieChartInfo pPie, int x, int y) {
        int pie_width = pPie.width;
        int pie_height = pPie.height;
        double x_radius = (double)pie_width / 2.0;
        double y_radius = (double)pie_height / 2.0;
        int x_center = (int)((double)x + x_radius + 0.5);
        int y_center = (int)((double)y + y_radius + 0.5);
        int delta_y = this.chartArea.deltaY;
        int i = 0;
        double start_angle = 135.0;
        while (i < pie_data.num_slices_pie && start_angle > -180.0) {
            double end_angle;
            double arc_angle = pie_data.percents[i].pct * 360.0;
            if (arc_angle == 0.0) {
                end_angle = start_angle;
            } else {
                end_angle = start_angle - arc_angle;
                if (!(end_angle > 0.0)) {
                    double angle = start_angle > 0.0 ? 0.0 : JCChartUtil.degToRad(start_angle);
                    Point[] points = new Point[4];
                    points[0] = new Point((int)((double)x_center + Math.cos(angle) * x_radius + 0.5), (int)((double)y_center - Math.sin(angle) * y_radius + 0.5));
                    points[1] = new Point(points[0].x, points[0].y + delta_y);
                    angle = end_angle < -180.0 ? JCChartUtil.degToRad(-180.0) : JCChartUtil.degToRad(end_angle);
                    points[3] = new Point((int)((double)x_center + Math.cos(angle) * x_radius + 0.5), (int)((double)y_center - Math.sin(angle) * y_radius));
                    points[2] = new Point(points[3].x, points[3].y + delta_y);
                    JCFillStyle fstyle = this.getPieSliceFillStyle(pie_data, i);
                    Polygon poly = new Polygon();
                    int j = 0;
                    while (j < points.length) {
                        poly.addPoint(points[j].x, points[j].y);
                        ++j;
                    }
                    fstyle.fillPolygonShadow(gc, poly);
                    if (gc.getColor() != this.chartArea.getForeground()) {
                        gc.setColor(this.chartArea.getForeground());
                    }
                    gc.drawLine(points[0].x, points[0].y, points[1].x, points[1].y);
                }
            }
            ++i;
            start_angle = end_angle;
        }
        if (gc.getColor() != this.chartArea.getForeground()) {
            gc.setColor(this.chartArea.getForeground());
        }
        gc.drawLine(x, y_center, x, y_center + delta_y);
        gc.drawArc(x, y + delta_y, pie_width, pie_height, 0, -180);
    }

    private void drawPieLines(Graphics gc, ChartDataViewSeries[] seriesList, PieData pie_data, PieChartInfo pPie, int x, int y, int pie_num) {
        double x_radius = (double)pPie.width / 2.0;
        double y_radius = (double)pPie.height / 2.0;
        int x1 = pPie.pos[pie_num].cx = (int)((double)x + Math.floor(x_radius));
        int y1 = pPie.pos[pie_num].cy = (int)((double)y + Math.floor(y_radius));
        if (gc.getColor() != this.chartArea.getForeground()) {
            gc.setColor(this.chartArea.getForeground());
        }
        int lasti = -1;
        double start_angle = 135.0;
        int prevDrawnSlice = pie_data.lastDrawnSlice;
        int i = 0;
        while (i < pie_data.num_slices_pie) {
            int y2 = -1;
            int x2 = -1;
            double arc_angle = pie_data.percents[i].pct * 360.0;
            if (i == pie_data.lastDrawnSlice && (arc_angle = start_angle - 135.0) <= 0.0) {
                arc_angle += 360.0;
            }
            if (arc_angle != 0.0) {
                Point offset;
                int int_angle = (int)Math.round(start_angle);
                x2 = (int)Math.round((double)x1 + Math.cos(JCChartUtil.degToRad(int_angle)) * Math.floor(x_radius));
                y2 = (int)Math.round((double)y1 - Math.sin(JCChartUtil.degToRad(int_angle)) * Math.floor(y_radius));
                if (!pie_data.exploded[i] || !pie_data.exploded[prevDrawnSlice]) {
                    gc.drawLine(x1, y1, x2, y2);
                }
                if (pie_data.exploded[i]) {
                    offset = pPie.pos[pie_num].offset[i];
                    gc.drawLine(x1 + offset.x, y1 + offset.y, x2 + offset.x, y2 + offset.y);
                }
                if (pie_data.exploded[prevDrawnSlice]) {
                    offset = pPie.pos[pie_num].offset[prevDrawnSlice];
                    gc.drawLine(x1 + offset.x, y1 + offset.y, x2 + offset.x, y2 + offset.y);
                }
                prevDrawnSlice = i;
                if ((start_angle -= (double)Math.round(arc_angle)) < 0.0) {
                    start_angle += 360.0;
                }
            }
            pPie.pos[pie_num].coord[i].x = x2;
            pPie.pos[pie_num].coord[i].y = y2;
            if (x2 >= 0) {
                int j = i - 1;
                while (j >= 0 && pPie.pos[pie_num].coord[j].x == -1) {
                    pPie.pos[pie_num].coord[j].x = x2;
                    pPie.pos[pie_num].coord[j].y = y2;
                    --j;
                }
                lasti = i;
            }
            ++i;
        }
        i = lasti + 1;
        while (i < pie_data.num_slices_pie) {
            pPie.pos[pie_num].coord[i].x = pPie.pos[pie_num].coord[0].x;
            pPie.pos[pie_num].coord[i].y = pPie.pos[pie_num].coord[0].y;
            ++i;
        }
    }

    private void sortWrapper(PieData pie_data, int num_slices, JCSortInterface si) {
        Vector v = new Vector();
        int i = 0;
        while (i < num_slices) {
            Vector<PieSortPoint> iv = new Vector<PieSortPoint>();
            iv.addElement(pie_data.sortPoints[i]);
            v.addElement(iv);
            ++i;
        }
        new JCqsort(v, si).sort(0);
        int i2 = 0;
        while (i2 < num_slices) {
            pie_data.sortPoints[i2] = (PieSortPoint)((Vector)v.elementAt(i2)).elementAt(0);
            ++i2;
        }
    }

    private JCFillStyle getPieSliceFillStyle(PieData pie_data, int slice) {
        JCFillStyle fstyle = null;
        if (slice == pie_data.other_slice && pie_data.other_flag != 0) {
            fstyle = this.dataObject.getPieChartFormat().getOtherStyle().getFillStyle();
        } else {
            int index = pie_data.percents[slice].index;
            if (index >= 0) {
                fstyle = this.dataObject.getSeries()[index].getStyle().getFillStyle();
            }
        }
        return fstyle;
    }

    void calcTransientData() {
        if (!this.dataObject.isChanged() && this.dataObject.getTransientData() != null) {
            return;
        }
        ChartDataViewSeries[] seriesList = this.dataObject.getSeries();
        int num_slices = this.dataObject.getNumSeries();
        Point firstLast = this.dataObject.getFirstLast();
        if (firstLast == null) {
            return;
        }
        this.num_pies = Math.max(firstLast.y - firstLast.x + 1, 0);
        if (this.num_pies == 0) {
            return;
        }
        PieChartInfo pPie = null;
        pPie = new PieChartInfo();
        pPie.pos = new PiePosition[this.num_pies];
        pPie.data = new PieData[this.num_pies];
        pPie.num_pies = this.num_pies;
        int i = 0;
        while (i < this.num_pies) {
            pPie.pos[i] = new PiePosition();
            pPie.pos[i].coord = new Point[num_slices + 1];
            pPie.pos[i].offset = new Point[num_slices + 1];
            int j = 0;
            while (j <= num_slices) {
                pPie.pos[i].coord[j] = new Point(-2, -2);
                pPie.pos[i].offset[j] = new Point(0, 0);
                ++j;
            }
            pPie.pos[i].order = new short[num_slices + 1];
            pPie.data[i] = new PieData();
            pPie.data[i].sortPoints = new PieSortPoint[num_slices];
            int j2 = 0;
            while (j2 < num_slices) {
                pPie.data[i].sortPoints[j2] = new PieSortPoint();
                ++j2;
            }
            pPie.data[i].percents = new PiePercent[num_slices + 1];
            pPie.data[i].exploded = new boolean[num_slices + 1];
            int j3 = 0;
            while (j3 < num_slices + 1) {
                pPie.data[i].percents[j3] = new PiePercent();
                pPie.data[i].exploded[j3] = false;
                ++j3;
            }
            ++i;
        }
        this.first_point = seriesList[0].getFirstPoint();
        pPie.other_flag = 0;
        int pie_num = 0;
        while (pie_num < this.num_pies) {
            int other_flag = this.computeOtherSlice(seriesList, pie_num + this.first_point, num_slices, pPie.data[pie_num]);
            int other_slice = pPie.data[pie_num].other_slice;
            int num_slices_pie = pPie.data[pie_num].num_slices_pie;
            int i2 = 0;
            while (i2 < num_slices_pie) {
                pPie.pos[pie_num].order[i2] = (short)pPie.data[pie_num].percents[i2].index;
                if (pPie.data[pie_num].percents[i2].pct > 0.0) {
                    pPie.data[pie_num].lastDrawnSlice = i2;
                }
                ++i2;
            }
            while (i2 <= num_slices) {
                pPie.pos[pie_num].order[i2] = -1;
                ++i2;
            }
            if (other_flag > 0) {
                pPie.pos[pie_num].order[pPie.data[pie_num].other_slice] = -10;
            }
            pPie.other_flag |= other_flag;
            ++pie_num;
        }
        this.dataObject.setTransientData(pPie);
        this.dataObject.setChanged(false);
    }

    JCDataIndex pick(Point p, int focus) {
        int row;
        JCDataIndex di = null;
        PieChartInfo pPie = (PieChartInfo)this.dataObject.getTransientData();
        JCPieChartFormat format = this.dataObject.getPieChartFormat();
        PieData pie_data = new PieData();
        pie_data.sortPoints = null;
        pie_data.percents = null;
        int tolerance = 0;
        ChartDataViewSeries[] seriesList = this.dataObject.getSeries();
        Rectangle rect = this.chartArea.getDrawingArea();
        int num_slices = this.dataObject.getNumSeries();
        pie_data.sortPoints = new PieSortPoint[num_slices];
        int j = 0;
        while (j < num_slices) {
            pie_data.sortPoints[j] = new PieSortPoint();
            ++j;
        }
        pie_data.percents = new PiePercent[num_slices + 1];
        pie_data.exploded = new boolean[num_slices + 1];
        int j2 = 0;
        while (j2 < num_slices + 1) {
            pie_data.percents[j2] = new PiePercent();
            pie_data.exploded[j2] = false;
            ++j2;
        }
        int delta_y = this.chartArea.deltaY;
        double inclination = JCChartUtil.degToRad(Math.max(0.0, (double)this.chartArea.getElevation()));
        double cos_inclination = Math.cos(inclination);
        int pie_width = pPie.width;
        int pie_height = pPie.height;
        if (pie_width == 0 || pie_height == 0) {
            return di;
        }
        int pie_offset = (this.box_width - pie_width) / 2;
        if (pie_offset < 0) {
            pie_offset = 0;
        }
        double a = (double)pie_width / 2.0;
        double b = (double)pie_height / 2.0;
        int column = (p.x - rect.x) / this.box_width;
        if (column >= this.num_pies_line) {
            column = this.num_pies_line - 1;
        }
        if ((row = (p.y - rect.y) / this.box_height) >= this.num_lines) {
            row = this.num_lines - 1;
        }
        int pie_num = row * this.num_pies_line + column + seriesList[0].firstPoint;
        int adjusted_pie_num = pie_num - seriesList[0].firstPoint;
        int box_x = rect.x;
        int box_y = rect.y;
        int x = (box_x += column * this.box_width) + pie_offset;
        int y = (box_y += row * this.box_height) + (this.box_height - pie_height - delta_y - this.label_height) / 2;
        int center_x = x + (int)Math.round((double)pie_width / 2.0);
        int center_y = y + (int)Math.round((double)pie_height / 2.0);
        int set = -1;
        int point = -1;
        if (adjusted_pie_num < this.num_pies && p.x >= box_x && p.x <= box_x + this.box_width && p.y >= box_y && p.y <= box_y + this.box_height) {
            int other_flag = this.computeOtherSlice(seriesList, pie_num, num_slices, pie_data);
            int[] ret = this.pie_hit(center_x, center_y, a, b, delta_y, p.x, p.y);
            int hit = ret[0];
            double angle = 0.0;
            switch (hit) {
                case 1: {
                    int r = ret[1];
                    if (p.x == center_x) {
                        angle = p.y < center_y ? 90 : -90;
                    } else {
                        angle = JCChartUtil.radToDeg(Math.atan((double)(center_y - p.y) / (double)(p.x - center_x)));
                        if (p.x < center_x) {
                            angle += 180.0;
                        }
                    }
                    tolerance = 0;
                    break;
                }
                case 2: {
                    int r = ret[1];
                    if (p.x == center_x) {
                        angle = -90.0;
                    } else {
                        angle = JCChartUtil.radToDeg(Math.atan((double)(-r) / (double)(p.x - center_x)));
                        if (p.x < center_x) {
                            angle += 180.0;
                        }
                    }
                    tolerance = 0;
                    break;
                }
                case 0: {
                    double sin_a;
                    double cos_a;
                    double dy;
                    double dx;
                    if (p.y < center_y) {
                        if (p.x == center_x) {
                            angle = 90.0;
                        } else {
                            angle = JCChartUtil.radToDeg(Math.atan((double)(center_y - p.y) / (double)(p.x - center_x)));
                            if (p.x < center_x) {
                                angle += 180.0;
                            }
                        }
                        dx = p.x - center_x;
                        dy = p.y - center_y;
                        cos_a = Math.cos(JCChartUtil.degToRad(angle));
                        sin_a = Math.sin(JCChartUtil.degToRad(angle));
                        tolerance = (int)Math.round(Math.sqrt(dx * dx + dy * dy) - a * b / Math.sqrt(b * b * cos_a * cos_a + a * a * sin_a * sin_a));
                        tolerance = Math.max(tolerance, 0);
                        break;
                    }
                    if (p.y > center_y + delta_y) {
                        if (p.x == center_x) {
                            angle = -90.0;
                        } else {
                            angle = JCChartUtil.radToDeg(Math.atan((double)(center_y + delta_y - p.y) / (double)(p.x - center_x)));
                            if (p.x < center_x) {
                                angle += 180.0;
                            }
                        }
                        dx = p.x - center_x;
                        dy = p.y - (center_y + delta_y);
                        cos_a = Math.cos(JCChartUtil.degToRad(angle));
                        sin_a = Math.sin(JCChartUtil.degToRad(angle));
                        tolerance = (int)Math.round(Math.sqrt(dx * dx + dy * dy) - a * b / Math.sqrt(b * b * cos_a * cos_a + a * a * sin_a * sin_a));
                        tolerance = Math.max(tolerance, 0);
                        break;
                    }
                    if (p.x < x) {
                        angle = 180.0;
                        tolerance = x - p.x;
                        break;
                    }
                    if (p.x > x + pie_width) {
                        angle = 0.0;
                        tolerance = p.x - (x + pie_width);
                        break;
                    }
                    angle = p.x < center_x ? 180 : 0;
                    tolerance = 0;
                    break;
                }
            }
            if (cos_inclination != 0.0) {
                double tmp_angle = angle;
                angle = JCChartUtil.radToDeg(Math.atan(Math.tan(JCChartUtil.degToRad(tmp_angle)) / cos_inclination));
                if (Math.cos(JCChartUtil.degToRad(tmp_angle)) <= 0.0) {
                    angle += 180.0;
                }
            }
            if (angle > 135.0) {
                angle -= 360.0;
            }
            int slice_no = 0;
            if (!pie_data.zero_pie) {
                double end_angle = 0.0;
                double start_angle = 0.0;
                int i = 0;
                i = 0;
                start_angle = 135.0;
                while (i < pie_data.num_slices_pie) {
                    double arc_angle = pie_data.percents[i].pct * 360.0;
                    if (arc_angle == 0.0) {
                        end_angle = start_angle;
                    } else {
                        end_angle = start_angle - arc_angle;
                        if (end_angle <= angle && angle <= start_angle) {
                            slice_no = other_flag != 0 && i == pie_data.other_slice ? -10 : pie_data.percents[i].index;
                            if (!pie_data.exploded[i] || (tolerance -= format.getExplodeOffset()) >= 0) break;
                            tolerance = 0;
                            break;
                        }
                    }
                    ++i;
                    start_angle = end_angle;
                }
            }
            set = slice_no;
            point = pie_num;
        }
        if (set >= 0 && point >= 0) {
            di = new JCDataIndex(point, seriesList[set], set);
            di.distance = tolerance;
        } else if (set == -10 && point >= 0) {
            di = new JCDataIndex(point, null, set);
            di.distance = tolerance;
        }
        return di;
    }

    private int[] pie_hit(int center_x, int center_y, double a, double b, int edge, int e_x, int e_y) {
        int[] ret = new int[2];
        double aa = a * a;
        double x = e_x - center_x;
        double xx = x * x;
        if (aa < xx) {
            ret[0] = 0;
            return ret;
        }
        double y = b / a * Math.sqrt(aa - xx);
        if ((double)e_y < (double)center_y - y || (double)e_y > (double)(center_y + edge) + y) {
            ret[0] = 0;
            return ret;
        }
        ret[1] = (int)Math.round(y);
        ret[0] = (double)e_y < (double)center_y + y ? 1 : 2;
        return ret;
    }

    Point unpick(int pt, int seriesIndex) {
        return this.find_point(seriesIndex, pt);
    }

    private Point find_point(int set, int point) {
        ChartDataViewSeries[] seriesList = this.dataObject.getSeries();
        int nsets = seriesList.length;
        if (set != -10 && !seriesList[set].isShowing) {
            return null;
        }
        PieChartInfo pPie = (PieChartInfo)this.dataObject.getTransientData();
        double cos_inclination = Math.cos(JCChartUtil.degToRad(Math.max(0, this.chartArea.getElevation())));
        int pix_x = -1;
        int pix_y = -1;
        double theta = 0.0;
        double angle = 0.0;
        int i = 0;
        while (i < nsets + 1) {
            short order = pPie.pos[point].order[i];
            if (order == -1) {
                return null;
            }
            if (order != -2 && order == set) {
                double y2;
                double x2;
                double x1 = pPie.pos[point].coord[i].x;
                double y1 = pPie.pos[point].coord[i].y;
                if (x1 == -2.0) {
                    return null;
                }
                if (i == nsets || pPie.pos[point].order[i + 1] == -1) {
                    x2 = pPie.pos[point].coord[0].x;
                    y2 = pPie.pos[point].coord[0].y;
                } else {
                    x2 = pPie.pos[point].coord[i + 1].x;
                    y2 = pPie.pos[point].coord[i + 1].y;
                }
                y1 = (y1 - (double)pPie.pos[point].cy) / cos_inclination + (double)pPie.pos[point].cy;
                y2 = (y2 - (double)pPie.pos[point].cy) / cos_inclination + (double)pPie.pos[point].cy;
                double theta1 = Math.atan2((double)pPie.pos[point].cy - y1, x1 - (double)pPie.pos[point].cx);
                double theta2 = Math.atan2((double)pPie.pos[point].cy - y2, x2 - (double)pPie.pos[point].cx);
                theta = theta1 - theta2;
                if (theta < 0.0) {
                    theta += Math.PI * 2;
                }
                if ((theta = theta1 - theta / 2.0) <= -Math.PI) {
                    theta += Math.PI * 2;
                }
                if (theta == 1.5707963267948966) {
                    pix_x = pPie.pos[point].cx;
                    pix_y = pPie.pos[point].cy - pPie.height / 2;
                    break;
                }
                if (theta == -1.5707963267948966) {
                    pix_x = pPie.pos[point].cx;
                    pix_y = pPie.pos[point].cy + pPie.height / 2;
                    break;
                }
                double a = (double)pPie.width / 2.0;
                double tant = Math.tan(theta);
                x1 = Math.sqrt(a * a / (1.0 + tant * tant));
                if (theta > 1.5707963267948966 || theta < -1.5707963267948966) {
                    x1 = -x1;
                }
                y1 = x1 * tant * cos_inclination;
                pix_x = (int)((double)pPie.pos[point].cx + x1);
                pix_y = (int)((double)pPie.pos[point].cy - y1);
                break;
            }
            ++i;
        }
        angle = theta;
        return new Point(pix_x, pix_y);
    }

    private void calcExplodeOffset(int start_angle, int bisect_angle, int space, int max, Point offset) {
        int dist = space;
        int angle = start_angle - bisect_angle;
        if (angle < 0) {
            angle += 360;
        }
        if (angle >= 0 && angle <= 90) {
            offset.x = (int)Math.round(Math.cos(JCChartUtil.degToRad(angle)) * (double)dist);
            offset.y = -((int)Math.round(Math.sin(JCChartUtil.degToRad(angle)) * (double)dist));
        } else if (angle > 90 && angle <= 180) {
            offset.x = -((int)Math.round(Math.sin(JCChartUtil.degToRad(angle -= 90)) * (double)dist));
            offset.y = -((int)Math.round(Math.cos(JCChartUtil.degToRad(angle)) * (double)dist));
        } else if (angle > 180 && angle <= 270) {
            offset.x = -((int)Math.round(Math.cos(JCChartUtil.degToRad(angle -= 180)) * (double)dist));
            offset.y = (int)Math.round(Math.sin(JCChartUtil.degToRad(angle)) * (double)dist);
        } else if (angle > 270 && angle <= 360) {
            offset.x = (int)Math.round(Math.sin(JCChartUtil.degToRad(angle -= 270)) * (double)dist);
            offset.y = (int)Math.round(Math.cos(JCChartUtil.degToRad(angle)) * (double)dist);
        }
    }
}

